Rem
Rem $Header: import_georaster.sql 23-apr-2007.11:11:37 zzhang Exp $
Rem
Rem import_georaster.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      import_georaster.sql
Rem
Rem    DESCRIPTION
Rem      import georaster data into Oracle as GeoRaster objects
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zzhang      04/23/07 - fix file path
Rem    bgouslin    01/07/07 - New version to fix Windoze format issue caused by
Rem                           some ADE bug
Rem    wexu        02/14/06 - fix file path 
Rem    wexu        08/05/04 - connect as scott 
Rem    qxie        09/24/03 - optionally add rasterid in init() call 
Rem    qxie        07/22/03 - importFrom interface
Rem    qxie        03/27/03 - add more NOTEs
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/24/02 - Created
Rem


-------------------------------------------------------------------
-- NOTE:
--
-- before you run this script, you MUST have the correct TIF images 
-- ready somewhere. Then you replace img1.tif and img2.tif with their 
-- correct paths in the script. In the following samples,the directory
-- of image files is assumed as "/georaster/data/" on a Linux platform.
-------------------------------------------------------------------


-------------------------------------------------------------------
-- initial setup for reading external image or georaster data files
--
-- individual files or a whole directory (external objects) must be 
-- granted reading permissions before calling importFrom.
-- This is due to Oracle RDBMS server security concern.
-------------------------------------------------------------------

connect system/manager;

call dbms_java.grant_permission('PUBLIC','SYS:java.io.FilePermission',
  '/georaster/data/img1.tif', 'read' );

call dbms_java.grant_permission('SCOTT','SYS:java.io.FilePermission',
  '/georaster/data/img2.tif', 'read' );
call dbms_java.grant_permission('MDSYS','SYS:java.io.FilePermission',
  '/georaster/data/img2.tif', 'read' );



-------------------------------------------------------------------
-- call importFrom to import image files into GeoRaster objects
-------------------------------------------------------------------

connect scott/tiger;

declare 
  geor MDSYS.SDO_GEORASTER;
begin

  -- initialize empty georaster objects to which the external images
  -- are to be imported

  delete from georaster_table where georid = 1 or georid = 2;
  insert into georaster_table 
    values( 1, 'TIFF', mdsys.sdo_geor.init('ST_RDT_1', 1) );
  insert into georaster_table 
    values( 2, 'TIFF', mdsys.sdo_geor.init('ST_RDT_1', 2) );

  --
  -- import the first TIFF image
  --
  select georaster into geor 
    from georaster_table where georid = 1 for update;
  mdsys.sdo_geor.importFrom(geor, '', 'TIFF', 'file',
    '/georaster/data/img1.tif');
  update georaster_table set georaster = geor where georid = 1;
  commit;

  --
  -- import another TIFF image
  --
  select georaster into geor
    from georaster_table where georid = 2 for update;
  mdsys.sdo_geor.importFrom(geor, '', 'TIFF','file', 
    '/georaster/data/img2.tif');
  update georaster_table set georaster = geor where georid = 2;
  commit;
end;
/
show errors;



-------------------------------------------------------------------
-- revoke reading permissions on external image files for security
-------------------------------------------------------------------

connect system/manager;

call dbms_java.revoke_permission('PUBLIC','SYS:java.io.FilePermission',
       '/georaster/data/img1.tif', 'read' );

call dbms_java.revoke_permission('SCOTT','SYS:java.io.FilePermission',
       '/georaster/data/img2.tif', 'read' );
call dbms_java.revoke_permission('MDSYS','SYS:java.io.FilePermission',
       '/georaster/data/img2.tif', 'read' );



-------------------------------------------------------------------
-- some quick checks to see if the data is loaded correctly
-------------------------------------------------------------------

connect scott/tiger;

set long 20000
set lines 20000
set pages 20000
SET NUMWIDTH 6
SET UNDERLINE =

-- display georaster metadata
column georaster format a70 heading "    The GeoRaster object"
select georid, georaster
  from georaster_table 
  where georid = 1 or georid = 2
  order by georid;

-- display each cell block of the georaster objects
column BLOCKMBR format a40 heading "    BLOCK MBR"
select rdt.rasterid, rdt.rowBLockNumber rowblockNum, 
  rdt.columnBlockNumber colBlockNum, rdt.blockMBR blockmbr,
  dbms_lob.getLength(rdt.rasterBlock) cellLength
  from st_rdt_1 rdt, georaster_table grt
  where rdt.rasterid = grt.georaster.rasterid
  order by rdt.rasterid, rdt.rowblocknumber asc;



